'use strict';

/* --------------------------------------------------------------
 package_template_controller.js 2016-01-22
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

gx.controllers.module(
// Module name
'package_template_controller',
// Module dependencies
['loading_spinner'], function (data) {
    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLE DEFINITION
    // ------------------------------------------------------------------------

    var
    /**
     * Module Selector
     *
     * @var {object}
     */
    $this = $(this),


    /**
     * Default Options
     *
     * @type {object}
     */
    defaults = {},


    /**
     * Final Options
     *
     * @var {object}
     */
    options = $.extend(true, {}, defaults, data),


    /**
     * Module Object
     *
     * @type {object}
     */
    module = {};

    // ------------------------------------------------------------------------
    // PRIVATE METHODS
    // ------------------------------------------------------------------------

    var _selectRow = function _selectRow($that) {
        var packageTemplateId = window.location.hash.substring(1);
        var withSpinner = undefined === $that ? false : true;
        $('.box-content').hide();
        $('.button-set').hide();
        $('.package-details').show();
        $('.detail-buttons').show();
        $that = $that || $('.sc_package_template_' + packageTemplateId);
        if (packageTemplateId) {
            $that.addClass('active');
            _loadContent(packageTemplateId, withSpinner);
            $('.gx-configuration-box').css('visibility', 'visible');
        }
    };

    var _loadContent = function _loadContent(packageTemplateId, withSpinner) {
        var $configBox = $('.gx-configuration-box');

        if (withSpinner) {
            var $spinner = jse.libs.loading_spinner.show($configBox);
        }

        $.ajax({
            url: 'admin.php?do=ShipcloudModuleCenterModule/GetPackageTemplate&templateId=' + packageTemplateId,
            type: 'GET',
            dataType: 'json'
        }).done(function (data) {
            $('.configuration-box-header h2').html(data['packages/' + packageTemplateId + '/name']);

            $('.configuration-box-form-content .package-details .package-weight').html(data['packages/' + packageTemplateId + '/weight']);
            $('.configuration-box-form-content .package-details .package-length').html(data['packages/' + packageTemplateId + '/length']);
            $('.configuration-box-form-content .package-details .package-width').html(data['packages/' + packageTemplateId + '/width']);
            $('.configuration-box-form-content .package-details .package-height').html(data['packages/' + packageTemplateId + '/height']);
            $('.configuration-box-form-content .package-details .package-type').html(data['packages/' + packageTemplateId + '/type_name']);

            $('.configuration-box-form-content .package-form-data .package_id_input').val(packageTemplateId);
            $('.configuration-box-form-content .package-form-data .package_name_input').val(data['packages/' + packageTemplateId + '/name']);
            $('.configuration-box-form-content .package-form-data .package_weight_input').val(data['packages/' + packageTemplateId + '/weight']);
            $('.configuration-box-form-content .package-form-data .package_length_input').val(data['packages/' + packageTemplateId + '/length']);
            $('.configuration-box-form-content .package-form-data .package_width_input').val(data['packages/' + packageTemplateId + '/width']);
            $('.configuration-box-form-content .package-form-data .package_height_input').val(data['packages/' + packageTemplateId + '/height']);
            $('.configuration-box-form-content .package-form-data .package_type_select').val(data['packages/' + packageTemplateId + '/type']);

            $('.configuration-box-form-content .package-form-data .is_default_input_row').toggle(data.is_default === false);
            $('.configuration-box-form-content .package-form-data .is_default_input').val(packageTemplateId);

            if ($spinner && withSpinner) {
                jse.libs.loading_spinner.hide($spinner);
            }
        });
    };

    var _setRowActive = function _setRowActive() {
        $('.gx-modules-table .dataTableRow.active').removeClass('active');

        _selectRow($(this));

        $('html, body').animate({
            scrollTop: 0
        });
    };

    var _showCreateFormData = function _showCreateFormData() {
        $('.gx-modules-table .dataTableRow.active').removeClass('active');

        $('.configuration-box-header h2').html('&nbsp;');

        $('.box-content').hide();
        $('.button-set').hide();
        $('.package-form-data').show();
        $('.create-form-data-buttons').show();

        $('.configuration-box-form-content .package-form-data .package_id_input').val('');
        $('.configuration-box-form-content .package-form-data .package_name_input').val('');
        $('.configuration-box-form-content .package-form-data .package_weight_input').val('');
        $('.configuration-box-form-content .package-form-data .package_length_input').val('');
        $('.configuration-box-form-content .package-form-data .package_width_input').val('');
        $('.configuration-box-form-content .package-form-data .package_height_input').val('');
        $('.configuration-box-form-content .package-form-data .package_type_select').val('parcel');

        $('.gx-configuration-box').css('visibility', 'visible');
    };

    var _showDetails = function _showDetails() {
        $('.box-content').hide();
        $('.button-set').hide();
        $('.package-details').show();
        $('.detail-buttons').show();
        $('.gx-configuration-box').css('visibility', 'visible');
    };

    var _showFormData = function _showFormData() {
        $('.box-content').hide();
        $('.button-set').hide();
        $('.package-form-data').show();
        $('.form-data-buttons').show();
        $('.gx-configuration-box').css('visibility', 'visible');
    };

    var _showDeleteConfirmation = function _showDeleteConfirmation() {
        $('.box-content').hide();
        $('.button-set').hide();
        $('.delete-confirmation').show();
        $('.confirm-delete-buttons').show();
        $('.gx-configuration-box').css('visibility', 'visible');
    };

    var _syncTitle = function _syncTitle() {
        if ($('.package-form-data .package_name_input').val()) {
            $('.configuration-box-header h2').text($('.package-form-data .package_name_input').val());
        } else {
            $('.configuration-box-header h2').html('&nbsp;');
        }
    };

    var _deletePackageTemplate = function _deletePackageTemplate() {
        $('#configuration-box-form').attr('action', 'admin.php?do=ShipcloudModuleCenterModule/DeletePackageTemplate&templateId=' + parseInt($('.configuration-box-form-content .package-form-data .package_id_input').val()));
        $('#configuration-box-form').submit();
    };

    // ------------------------------------------------------------------------
    // INITIALIZATION
    // ------------------------------------------------------------------------

    /**
     * Initialize method of the module, called by the engine.
     */
    module.init = function (done) {
        $('.gx-configuration-box').css('visibility', 'hidden');
        _selectRow();
        $('.gx-modules-table .dataTableRow').on('click', _setRowActive);
        $('.configuration-box-footer .edit-package-template, .bottom-save-bar .edit-package-template').on('click', _showFormData);
        $('.configuration-box-footer .cancel-package-template, .bottom-save-bar .cancel-package-template').on('click', _showDetails);
        $('.create-new-wrapper .add-package-template').on('click', _showCreateFormData);
        $('.configuration-box-footer .delete-package-template, .bottom-save-bar .delete-package-template').on('click', _showDeleteConfirmation);
        $('.configuration-box-footer .confirm-delete-package-template, .bottom-save-bar .confirm-delete-package-template').on('click', _deletePackageTemplate);
        $('.package-form-data .package_name_input').on('keyup', _syncTitle);
        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
